EvaluateScript("Layout.js");

function Menu(windowed)
{
	this.windowed = windowed; // Draw window?
	this.items = new Array();
	this.selection = 0;
	this.top_selection = 0;
	this.opened = false;
	this.tw = 0;
	this.th = 0;
	this.doWhile = function() {}
	this.spacing = 12;
	this.indent = 0;
	this.returnSelection = false;
	this.heading = "MENU";
	this.onRight = "";
	this.icons = false;
	this.style = true;
}

Menu.prototype.addItem = function(name, link, color)
{
	if (link == undefined)
	{
		link = Exit;
	}
	if (color == undefined)
	{
		color = Colors.Normal;
	}
	var item = new Object();
	item.name = name;
	item.link = link;
	item.color = color;
	item.enabled = true;
	this.items[this.items.length] = item;
}

Menu.prototype.open = function(x, y, w, h, style)
{
	Game.menuopen = true;
	h = h * this.spacing - 2;
	this.tw += w / 3;
	this.th += h / 3;
	if (this.tw == w && this.th == h)
	{
		this.opened = true;
	}
	if (this.opened == false)
	{
		window.drawWindow(x + (w / 2) - (this.tw / 2), y + (h / 2) - (this.th / 2), this.tw, this.th, this.style, this.heading, style);
	}
}

Menu.prototype.reset = function()
{
	this.tw = 0;
	this.th = 0;
	this.opened = false;
}

Menu.prototype.execute = function(x, y, w, h, style)
{
	Interrupt();
	if (this.opened == false && this.windowed == true)
	{
		this.open(x, y, w, h, style);
	}
	if (this.opened == false && this.windowed == false)
	{
		this.opened = true;
	}
	// After opening the window (if you had too), draw the menu items and cursors
	if (this.opened == true )
	{
		this.doWhile();
		this.draw(x, y, w, h, style);
		// Put arrows and such here
		if (LastPush())
		{
			if (IsKeyPressed(KEY_RIGHT))
			{
				KeyPressed();
				Game.menuopen = false;
				return -3;
			}
			if (IsKeyPressed(KEY_LEFT))
			{
				KeyPressed();
				Game.menuopen = false;
				return -2;
			}
			if (IsKeyPressed(KEY_DOWN))
			{
				KeyPressed();
				if (this.selection < this.items.length - 1)
				{
					this.selection ++;
					if (this.selection >= this.top_selection + h / 10)
					{
						this.top_selection ++;
					}
				}
			}
			if (IsKeyPressed(KEY_UP))
			{
				KeyPressed();
				if (this.selection > 0)
				{
					this.selection --;
					if (this.selection < this.top_selection)
					{
						this.top_selection --;
					}
				}
			}
			if (IsKeyPressed(Game.accept))
			{
				if (this.items[this.selection].enabled)
				{
					KeyPressed();
					Game.menuopen = false;
					if (this.returnSelection)
					{
						return this.selection;
					}
					else
						this.items[this.selection].link();
				}
				else
				{
					KeyPressed(false);
				}
			}
			if (IsKeyPressed(Game.cancel))
			{
				KeyPressed(false);
				Game.menuopen = false;
				return -1;
			}
		}
	}
}

Menu.prototype.draw = function(x, y, w, h, style)
{
	h = h * (this.spacing) - 2;
	if (this.windowed == true)
	{
		window.drawWindow(x, y, w, h, this.style, this.heading, style);
		for (var i = 0; i < this.items.length; i ++)
		{
			if (this.items[i].enabled)
			{
				if (this.icons == false)
				{
					font.drawText(x + this.indent, y + i * (this.spacing), this.items[i].name, "left", this.items[i].color);
				}
				else
					font.iconText(x + this.indent, y + i * (this.spacing), this.items[i], this.items[i].color);
				switch (this.onRight)
				{
					case "":
						break;
					case "Amount":
						font.drawText(x + w, y + i * (this.spacing) + 2, this.items[i].amount, "right", this.items[i].color);
						font.littleText(x + w - 36, y - 12, "AMOUNT");
						break;
					case "MP":
						font.drawText(x + w, y + i * (this.spacing), this.items[i].mp, "right", this.items[i].color);
						font.littleText(x + w - 12, y - 12, "MP");
						break;
					case "Cost":
						font.drawText(x + w, y + i * (this.spacing), this.items[i].cost, "right", this.items[i].color);
						font.littleText(x + w - 30, y - 12, "PRICE");
						break;
				}
			}
			if (!this.items[i].enabled)
			{
				if (this.icons == false)
				{
					font.drawText(x + this.indent, y + i * (this.spacing), this.items[i].name, "left", Colors.Grayed);
				}
				else
					font.iconText(x + this.indent, y + i * (this.spacing), this.items[i], Colors.Grayed);
				switch (this.onRight)
				{
					case "":
						break;
					case "Amount":
						font.drawText(x + w, y + i * (this.spacing) + 2, this.items[i].amount, "right", Colors.Grayed);
						font.littleText(x + w - 36, y - 12, "AMOUNT");
						break;
					case "MP":
						font.drawText(x + w, y + i * (this.spacing), this.items[i].mp, "right", Colors.Grayed);
						font.littleText(x + w - 12, y - 12, "MP");
						break;
					case "Cost":
						font.drawText(x + w, y + i * (this.spacing), this.items[i].cost, "right", Colors.Grayed);
						font.littleText(x + w - 30, y - 12, "PRICE");
						break;
				}
			}
		}
	}
	if (style == undefined)
	{
		DrawCursor(x + this.indent, y + this.selection * (this.spacing));
	}
	if (style == "Away")
	{
		DrawCursor(x + this.indent, y + this.selection * (this.spacing), true);
	}
	// Put arrows and such here
}

Menu.prototype.control = function(h)
{
	if (LastPush())
	{
		if (IsKeyPressed(KEY_RIGHT))
		{
			KeyPressed();
			Game.menuopen = false;
			return -3;
		}
		if (IsKeyPressed(KEY_LEFT))
		{
			KeyPressed();
			Game.menuopen = false;
			return -2;
		}
		if (IsKeyPressed(KEY_DOWN))
		{
			KeyPressed();
			if (this.selection < this.items.length - 1)
			{
				this.selection ++;
				if (this.selection >= this.top_selection + h / 10)
				{
					this.top_selection ++;
				}
			}
		}
		if (IsKeyPressed(KEY_UP))
		{
			KeyPressed();
			if (this.selection > 0)
			{
				this.selection --;
				if (this.selection < this.top_selection)
				{
					this.top_selection --;
				}
			}
		}
		if (IsKeyPressed(Game.accept))
		{
			if (this.items[this.selection].enabled)
			{
				KeyPressed();
				Game.menuopen = false;
				if (this.returnSelection)
				{
					return this.selection;
				}
				else
					this.items[this.selection].link();
			}
			else
			{
				KeyPressed(false);
			}
		}
		if (IsKeyPressed(Game.cancel))
		{
			KeyPressed(false);
			Game.menuopen = false;
			return -1;
		}
	}
}

Menu.prototype.moveDown = function()
{
	if (this.selection < this.items.length - 1)
	{
		this.selection ++;
		if (this.selection >= this.top_selection + h / 10)
		{
			this.top_selection ++;
		}
	}
}

Menu.prototype.moveUp = function()
{
	if (this.selection > 0)
	{
		this.selection --;
		if (this.selection < this.top_selection)
		{
			this.top_selection --;
		}
	}
}

Menu.prototype.executeAlone = function(x, y, w, h)
{
	Game.menuopen = true;
	this.doWhile();
	var background = GrabImage(0, 0, 320, 240);
	while (Game.menuopen)
	{
		background.blit(0, 0);
		var s = this.execute(x, y, w, h);
		FlipScreen();
	}
	return s;
}

Menu.prototype.executeMap = function(x, y, w, h)
{
	Game.menuopen = true;
	Game.currentmenu = this;
	Game.currentmenu.x = x;
	Game.currentmenu.y = y;
	Game.currentmenu.w = w;
	Game.currentmenu.h = h;
}